application_yml_path="app/config/application-prod.yml"
application_prepopulateUsers_yml_path="app/config/application-prepopulateUsers.yml"
frontend_env_path="app/config/frontend/.env"
docker_compose_env_path=".env"

function yes_or_no {
    while true; do
        read -p "$* [y/n]: " yn
        case $yn in
            [Yy]*) return 0  ;;  
            [Nn]*) echo "" ; return  1 ;;
        esac
    done
}

function openBrowser {
  python -mwebbrowser ${baseUrl}:${port}
}

function useCorrectApplicationYml {
  if [ $1 == "true" ] ; then
    mv app/config/application-prod-demoData.yml app/config/application-prod.yml
    echo "Using application-prod-demoData.yml"
  else
    rm app/config/application-prod-demoData.yml
    echo "Using application-prod.yml"
  fi
}

function startPortrait {
  # start
  docker-compose up -d
}

function setLogin {
  adminLoginPlaceholder="%adminLogin"
  adminPasswordPlaceholder="%adminPassword"

  sed -i'.bak' -e "s/$adminLoginPlaceholder/$1/g" $application_prepopulateUsers_yml_path || { echo 'Setting admin login failed aborting setup'; exit 1; }
  sed -i'.bak' -e "s/$adminPasswordPlaceholder/$2/g" $application_prepopulateUsers_yml_path || { echo 'Setting admin password failed aborting setup'; exit 1; }
  rm "$application_yml_path.bak"

}

function setSecret {
  secretPlaceholder="%secret"
  customSecret=$(openssl rand -base64 172 | tr -d '\n' ; echo)

  sed -i'.bak' -e "s|$secretPlaceholder|$customSecret|g" $application_yml_path || { echo 'Setting secret failed aborting setup'; exit 1; }
  rm "$application_yml_path.bak"

}

function setbaseUrl {
  baseUrlPlaceholder="%baseUrl"
  sanitizedBaseUrl=${1%/}

  #backend
  sed -i'.bak' -e "s,$baseUrlPlaceholder,$sanitizedBaseUrl,g" $application_yml_path || { echo 'Setting base url in backend failed aborting setup'; exit 1; }
  rm "$application_yml_path.bak"

  #frontend
  sed -i'.bak' -e "s,$baseUrlPlaceholder,$sanitizedBaseUrl,g" $frontend_env_path || { echo 'Setting base url in frontend failed aborting setup'; exit 1; }
  rm "$frontend_env_path.bak"

}

function setDockerComposeEnv() {
      echo "PROXY_PORT="$1 >> $docker_compose_env_path
      echo "CODE_SERVER_PW="$2 >> $docker_compose_env_path
      echo "COMPOSE_PROJECT_NAME="$3 >> $docker_compose_env_path
}

function setApplicationYmlConfigs {
  titlePlaceholder="%title"
  ownerPlaceholder="%owner"
  adminLoginPlaceholder="%adminLogin"

  sed -i'.bak' -e "s/$titlePlaceholder/$1/g" $application_yml_path
  sed -i'.bak' -e "s/$ownerPlaceholder/$2/g" $application_yml_path
  sed -i'.bak' -e "s/$adminLoginPlaceholder/$3/g" $application_yml_path
  rm "$application_yml_path.bak"

}



function checkDocker {
  if ! command -v docker &> /dev/null
  then
    echo "This installer requires 'docker'. Install it please, and then run this installer again."
    exit
  fi
}

function checkDockerCompose {
  if ! command -v docker-compose &> /dev/null
  then
    echo "This installer requires 'docker-compose'. Install it please, and then run this installer again."
    exit
  fi
}

function checkOpenSSL {
  if ! command -v openssl &> /dev/null
  then
    echo "This installer requires 'openssl'. Install it please, and then run this installer again."
    exit
  fi
}

# check prerequisites
checkDocker
checkDockerCompose
checkOpenSSL

# intro
echo ""
echo "##############################"
echo "Install Portrait App on Docker"
echo "##############################"
echo ""
echo "Note: The Docker engine and Docker-Compose must already be installed."
echo "      Go to https://docs.portrait.app to learn how to setup Docker"
echo ""

yes_or_no "Do you wish to install Portrait now at the current directory ($PWD)?" && echo "Configuration:" || exit

# configuration 
read -p "  Step 1 of 8: Set the title of your App (default: Portrait App): "  appTitle
appTitle=${appTitle:-'Portrait App'}

read -p "  Step 2 of 8: Set the owner of your App (default: Treskon GmbH): "  appOwner
appOwner=${appOwner:-'Treskon GmbH'}

read -p "  Step 3 of 8: Do you want to include demo data? [y/n]: "  demoData
if [ "$demoData" == "y" ] || [ "$demoData" == "Y" ];
then
  use_demo_data="true"
else
  use_demo_data="false"
fi

read -p "  Step 4 of 8: Set the URL under which Portrait will be accessible for end users (default: http://localhost): "  baseUrl
baseUrl=${baseUrl:-'http://localhost'}

read -p "  Step 5 of 8: Set the internal TCP port for the app (default: 80). You will set up an internal route to this port:"  port
port=${port:-'80'}

read -p "  Step 6 of 8: Define the admin-login - must be an email-address : "  adminLogin
if [ "$adminLogin" = "" ];
then
    echo "    ERROR: No login provided, aborting setup"
    exit
fi

read -s -p "  Step 7 of 8: Define the password for the administrator account (Portrait Web Login and VsCodeWeb Login): "  adminPass
if [ "$adminPass" = "" ];
then
    echo "    ERROR: No password provided, aborting setup"
    exit
fi

echo ""
read -p "  Step 8 of 8 OPTIONAL: Define a custom name for the docker project (leave blank for auto-generated) allowed characters [a-z0-9]:"  dockerProjectName
dockerProjectName=$(echo "$dockerProjectName" |  tr '[:upper:]' '[:lower:]' | tr -dc 'a-zA-Z0-9')
if [ -z "$dockerProjectName" ];
then
    dockerProjectName=portrait-$(uuidgen | tr -d '-' )
    echo "    INFO: Using the auto-generated name $dockerProjectName for this installation"
fi


echo ""
echo "Installation:"

# do work
useCorrectApplicationYml $use_demo_data
setApplicationYmlConfigs "$appTitle" "$appOwner" $adminLogin
setLogin $adminLogin $adminPass
setbaseUrl ${baseUrl}
setDockerComposeEnv $port $adminPass $dockerProjectName
setSecret
startPortrait

running="$(docker-compose ps --services --filter "status=running")"
services="$(docker-compose ps --services)"
if [ "$running" != "$services" ]; then
    echo "ERROR startup check 'docker-compose ps' and 'docker-compose logs'"
    exit
else
    mv setup.sh .setup.sh #hide setup
    echo ""
    echo "Portrait is installed and avalaible at ${baseUrl} -  it may take a few minutes until the app is ready."
    echo '  Login with: ' $adminLogin
    echo ""
fi



# give follow up recommendations
if [[ "${baseUrl}" == "http://localhost" ]]; then
  echo '  Warning: This looks like a development instance. Right now, you can only access Portrait only via localhost!'
else
  echo '  Warning: You might need to set up routing and SSL first, to open Portrait correctly!'
fi
echo ""
echo ""
# open browser (if possible, otherwise nothing happens)
if [[ "$OSTYPE" == "darwin"* ]]; then
  yes_or_no "Do you want to open Portrait now?" && openBrowser
fi
echo ""