set -e



function yes_or_no {
    while true; do
        read -p "$* [y/n]: " yn
        case $yn in
            [Yy]*) return 0  ;;
            [Nn]*) echo "" ; return  1 ;;
        esac
    done
}

function checkDependencies {
      # check if docker is installed
      if ! command -v docker &> /dev/null
      then
        echo "This script requires 'docker'. Install it please, and then run this script again."
        exit 1
      fi

      # check if docker-compose is installed
      if ! command -v docker-compose &> /dev/null
      then
        echo "This script requires 'docker-compose'. Install it please, and then run this script again."
        exit 1
      fi
}

function main {

    echo "##############################"
    echo "This script will change the baseUrl of your Portrait installation."
    echo "##############################"


    applicationYMLPath="app/config/application-prod.yml"
    frontendEnvPath="app/config/frontend/.env"

    activeBaseUrl=$(awk '/application:/,/url:/ { if ( $1 == "url:" ) { print $2 } }' $applicationYMLPath)
    echo "Current baseUrl: $activeBaseUrl"

    read -p "Please enter the new baseUrl: " newBaseUrl
    newBaseUrl=${newBaseUrl:-""}
    if [ -z "$newBaseUrl" ]; then
      echo "No baseUrl provided. Exiting."
      exit 1
    fi

    echo "Shutting down Portrait ..."
    docker-compose down

    sed -i "/application:/,/url:/ { s#url: .*#url: $newBaseUrl#; t; }" $applicationYMLPath
    sed -i "s|^NEXT_PUBLIC_PUBLIC_URL=.*|NEXT_PUBLIC_PUBLIC_URL=$newBaseUrl|" $frontendEnvPath
    sed -i "s|^NEXT_PUBLIC_API_URL=.*|NEXT_PUBLIC_API_URL=$newBaseUrl/api|" $frontendEnvPath

    echo "baseUrl changed to $newBaseUrl"
    echo "Restarting Portrait..."
    docker-compose up -d
    echo "Done."
}

main